﻿using VIRP_WEB.SoaServices;
using VIRP_WEB.BaseCode;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Xml;
using System.IO;
using System.Xml.Linq;
using System.Text.RegularExpressions;

namespace VIRP_WEB.Admin
{
    public partial class SettingsLogView : BasePage
    {
        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
                ServiceInterfaceManager.LogInformation("PAGE_LOAD", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                base.Page_Load(sender, e);

                STD_REGISTRY systemRegistry = ApplicationSession.SystemRegistry;
                AppSettings appSetting = ServiceInterfaceManager.APPSETTINGS_GET(HttpContext.Current.User.Identity.Name, systemRegistry.ID);
                if (appSetting != null)
                {
                    string query = "";
                    query = Request.QueryString["query"] as string;

                    switch (query)
                    {
                        case "1": //File Log View

                            string fileLogPath = string.Empty;
                            string validPath1 = "C:" + Path.DirectorySeparatorChar.ToString() + "Logs" + Path.DirectorySeparatorChar.ToString() + "VIRP" + Path.DirectorySeparatorChar.ToString() + "VIRP.log";
                            string validPath2 = "D:" + Path.DirectorySeparatorChar.ToString() + "Logs" + Path.DirectorySeparatorChar.ToString() + "VIRP" + Path.DirectorySeparatorChar.ToString() + "VIRP.log";

                            string tempPath = appSetting.FileLogPath.ToString();

                            if (tempPath == validPath2)
                                fileLogPath = validPath2;
                            else
                                fileLogPath = validPath1;
                            
                            if (!string.IsNullOrEmpty(fileLogPath)  && File.Exists(fileLogPath))
                            {
                                string logText = File.ReadAllText(fileLogPath);
                                txtOutput.Text = logText;
                            }
                            else
                            {
                                lblResult.Text = "The configured File Log Path is not valid and a file could not be generated to view.<br /><br />";
                                txtOutput.Visible = false;
                            }
                            break;
                        default:
                            {
                                lblResult.Text = "You have not selected a file to view. Please return to settings and pick a file.<br /><br />";
                                txtOutput.Visible = false;
                                break;
                            }
                    }
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }
    }
}